\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 16))
  markup-system-spacing = #'((basic-distance . 23))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  %ragged-last-bottom=##f
  system-count = #2
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Astăzi s-a născut Hristos"
  subtitle = " "
  %subsubtitle = "Op. 19"
  %poet = ""
  composer = \markup \center-column {"Timotei Popovici"
  \small "(1870 - 1950)" }
  %arranger = "io"
  %meter = "nu prea încet"
  tagline=""
}

global = {
  \key g \major
  %\autoBeamOff
  %\cadenzaOn
  \time 2/4
  %\partial 8
  \set Staff.midiInstrument = "clarinet"
}

womenWordsOne = \lyricmode {
  \set stanza = "1."
   As -- tăzi s-a năs -- cut Hris -- tos, 
   Me -- sia -- a, chip lu -- mi -- nos,
   Lă -- u -- daţi şi cân -- taţi 
   şi vă bu -- cu -- raţi! 
}

womenWordsTwo = \lyricmode {
  \set stanza = "2."
   Mi -- ti -- tel, în -- fă -- şe -- ţel,
   În scu -- tec de bum -- bă -- cel,
}

womenWordsThree = \lyricmode {
  \set stanza = "3."
  Vân -- tul ba -- te, nu-l răz -- ba-te,
  Nea -- ua nin -- ge, nu-l a -- tin-ge,
}

womenWordsFour = \lyricmode {
  \set stanza = "4."
  Şi de-a -- cum pâ -- nă-n ve -- ci-e
  Mi -- la Dom -- nu -- lui să fi-e,
}

altWords = \lyricmode {
  \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 
  Lă -- u -- daţi şi cân -- taţi 
  şi vă bu -- cu -- raţi!
  
}

menWords = \lyricmode {
  Lă -- u -- daţi şi cân -- taţi 
  şi vă bu -- cu -- raţi! 
  
}

sopMusic = \relative c' {
  d8^\p g^\< g g h^\> h a4\! d,8 g^\< g g h^\> h a4 \! \bar "||"
  c8.^\f c16 h4 e8 e d4 c8 h a a g4. r8
  \bar ":|."
}

altMusic = \relative c' {
  d8 d d d g g fis4  d8 d d d g g fis4
  a8. a16 g4 c8 c h4 c8 h a a g4. r8
}

tenorMusic = \relative c {
  r2 r r r
  c'8. c16 h4 e8 e d4 d8 d c c h4. r8
}

bassMusic =  \relative c {
  r2 r r r
  d8. d16 g4 c,8 e g4 d8 d d d g4. r8
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff = "staff" <<
     %\new Voice { \voiceOne \global \sopMusic }
     %\new Lyrics \with { alignAboveContext = "staff" } { \sopWords }
     %\new Voice { \voiceTwo \global \altMusic }   
     \new Voice { \global \sopMusic }
     \addlyrics { \womenWordsOne }
     \addlyrics { \womenWordsTwo }
     \addlyrics { \womenWordsThree }
     \addlyrics { \womenWordsFour }
    >>
    
     \new Staff <<
      \new Voice { \global \altMusic }   
      \addlyrics { \altWords }
     >>
    
     \new Staff <<
      \clef "G_8"
      \new Voice { \global \tenorMusic }
      \addlyrics { \menWords }
     >>
    
    \new Staff <<
      \clef bass
      \new Voice { \global \bassMusic }
      \addlyrics { \menWords }
      %\new Voice { \global \tenorMusic }
      %\new Lyrics \with { alignAboveContext = "staff" } { \tenorWords }
      %\new Voice { \voiceOne \global \tenorMusic }
      %\addlyrics { \tenWords }
      %\new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      %\addlyrics { \basWordsOne }
      %\addlyrics { \basWordsTwo }
      %\addlyrics { \basWordsThree }  
      %\addlyrics { \basWordsFour } 
    >>
  >>
>>

\score {
  \myScore
  \layout { 
    \context {
      \Staff
      \RemoveEmptyStaves
      \override VerticalAxisGroup.remove-first = ##t 
    } 
  }
}

midiOutput = \midi {
  \tempo 4 = 60
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}